% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_spike_contigs.R
\name{scan_spike_contigs}
\alias{scan_spike_contigs}
\title{pretty much what it says: scan spike contigs from a BAM or CRAM file}
\usage{
scan_spike_contigs(bam, spike, how = "max", param = NULL, mc.cores = 16, ...)
}
\arguments{
\item{bam}{the BAM or CRAM filename, or a vector of such filenames}

\item{spike}{the spike-in reference database (e.g. data(spike))}

\item{how}{how to summarize the per-spike coverage (max)}

\item{param}{a ScanBamParam object, or NULL (will default to MAPQ=20 etc)}

\item{mc.cores}{Number of cores to run on (default 16)}

\item{...}{additional arguments to pass to scanBamFlag()}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{     a CompressedGRangesList with bin- and spike-level coverage
}\if{html}{\out{</div>}}
}
\description{
default workflow is
}
\details{
\enumerate{
\item scan spike contigs and count fragments per contig or per bin.
\item fit the appropriate model for adjusting genomic contigs based on spikes.
\item scan and adjust binned fragment tallies along genomic contigs per above.
}

scan_spike_contigs implements step 1.

If multiple BAM or CRAM filenames are provided, all indices will be
checked before attempting to run through any of the files.
}
\examples{
library(GenomicRanges)
data(spike, package="spiky")
sb <- system.file("extdata", "example.spike.bam", package="spiky",
                  mustWork=TRUE) # switch to a CRAM
res <- scan_spike_contigs(sb, spike=spike) # use default ScanBamParam
summary(res)

}
\seealso{
\if{html}{\out{<div class="sourceCode">}}\preformatted{    Rsamtools::ScanBamParam
}\if{html}{\out{</div>}}
}
