% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepData.R
\name{prepData}
\alias{prepData}
\title{Prepare data from calcMetricRes to be in the right format for FDA}
\usage{
prepData(metricRes, x, y, sample_id = NULL, image_id = NULL, condition = NULL)
}
\arguments{
\item{metricRes}{a dataframe as calculated by calcMetricRes - requires
the columns ID (unique identifier of each row)}

\item{x}{the name of the x-axis of the spatial metric}

\item{y}{the name of the y-axis of the spatial metric}

\item{sample_id}{the spe \code{colData} variable to mark the sample}

\item{image_id}{the spe \code{colData} variable to mark the image}

\item{condition}{the spe \code{colData} variable to mark the condition}
}
\value{
returns a list with three entries, the unique ID, the functional
response Y and the weights
}
\description{
Prepare data from calcMetricRes to be in the right format for FDA
}
\examples{
# retrieve example data from Damond et al. (2019)
spe <- .loadExample()
metricRes <- calcMetricPerFov(spe, c("alpha", "Tc"),
    subsetby = "image_number", fun = "Gcross", marks = "cell_type",
    rSeq = seq(0, 50, length.out = 50), by = c(
        "patient_stage", "patient_id",
        "image_number"
    ),
    ncores = 1
)

# create a unique ID for each row
metricRes$ID <- paste0(
    metricRes$patient_stage, "|", metricRes$patient_id,
    "|", metricRes$image_number
)
dat <- prepData(metricRes, "r", "rs", sample_id = "patient_id",
image_id = "image_number", condition = "patient_stage")
}
