% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcMetric.R
\name{calcMetricPerFov}
\alias{calcMetricPerFov}
\title{Calculate a spatial metric on a \code{SpatialExperiment} object per field of view}
\usage{
calcMetricPerFov(
  spe,
  selection,
  subsetby,
  fun,
  marks = NULL,
  rSeq = NULL,
  by = NULL,
  continuous = FALSE,
  assay = "exprs",
  ncores = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{spe}{a \code{SpatialExperiment} object}

\item{selection}{the mark(s) you want to compare. NOTE: This is directional.
c(A,B) is not the same result as c(B,A).}

\item{subsetby}{the spe \code{colData} variable to subset the data by. This
variable has to be provided, even if there is only one sample.}

\item{fun}{the \code{spatstat} function to compute on the point pattern object}

\item{marks}{the marks to consider e.g. cell types}

\item{rSeq}{the range of r values to compute the function over}

\item{by}{the spe \code{colData} variable(s) to add to the meta data}

\item{continuous}{A boolean indicating whether the marks are continuous
defaults to FALSE}

\item{assay}{the assay which is used if \code{continuous = TRUE}}

\item{ncores}{the number of cores to use for parallel processing, default = 1}

\item{verbose}{logical indicating whether to print all information or not}

\item{...}{Other parameters passed to \code{spatstat.explore} functions}
}
\value{
a \code{dataframe} of the \code{spatstat} metric objects with the radius r, the
theoretical value of a Poisson process, the different border corrections
the fov number, the number of points and the centroid of the image
}
\description{
A function that takes a \code{SpatialExperiment} object as input and calculates a
spatial metric as implemented by \code{spatstat} per field of view.
}
\examples{
# retrieve example data from Damond et al. (2019)
spe <- .loadExample()
metricRes <- calcMetricPerFov(spe, c("alpha", "Tc"),
    subsetby = "image_number", fun = "Gcross", marks = "cell_type",
    rSeq = seq(0, 50, length.out = 50), by = c(
        "patient_stage", "patient_id",
        "image_number"
    ),
    ncores = 1
)
}
