% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparrowResult-methods.R
\name{logFC}
\alias{logFC}
\title{Extract the individual fold changes statistics for elements in the
expression object.}
\usage{
logFC(x, as.dt = FALSE)
}
\arguments{
\item{x}{A \code{\link[=SparrowResult]{SparrowResult()}}}

\item{as.dt}{If \code{FALSE} (default), the data.frame like thing that
this funciton returns will be set to a data.frame. Set this to \code{TRUE}
to keep this object as a \code{data.table}}
}
\value{
The log fold change `data.table``
}
\description{
Extract the individual fold changes statistics for elements in the
expression object.
}
\examples{
vm <- exampleExpressionSet(do.voom=TRUE)
gdb <- exampleGeneSetDb()
mg <- seas(vm, gdb, design = vm$design, contrast = 'tumor')
lfc <- logFC(mg)
}
