% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/platform_effect_normalization.R
\name{getNormRef}
\alias{getNormRef}
\title{Normalizes cell type profiles to a target dataset}
\usage{
getNormRef(puck, cell_type_means, gene_list, proportions)
}
\arguments{
\item{puck}{an object of type \linkS4class{SpatialRNA}, the target dataset}

\item{cell_type_means}{a data_frame (genes by cell types) for mean normalized
expression (see \code{\link{computeCellTypeInfo}})}

\item{gene_list}{a list of genes to be used for the normalization}

\item{proportions}{a named list (for each cell type) of proportion of the
cell type on the bulk dataset (not constrained to sum to 1)}
}
\value{
Returns \code{cell_type_means}, a data_frame (genes by cell types)
  for mean normalized cell type expression profiles in which platform effects
  have been removed to match the \linkS4class{SpatialRNA} data.
}
\description{
renormalizes \code{cell_type_means} to have average the same as the puck. The
average for each gene is weighted by cell type proportions given by
\code{proportions}.
}
\keyword{internal}
