% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialRNA.R
\name{createSpatialRNA}
\alias{createSpatialRNA}
\title{\code{\linkS4class{SpatialRNA}} object constructor}
\usage{
createSpatialRNA(
  coords,
  counts,
  nUMI = NULL,
  use_fake_coords = FALSE,
  require_int = TRUE
)
}
\arguments{
\item{coords}{data frame (or matrix) containing x and y coordinates for each
pixel (identified by barcode)}

\item{counts}{matrix (or dgCMatrix) of gene expression counts, with genes as
rows and pixels as columns (named by pixel barcode)}

\item{nUMI}{optional, numeric vector of total UMI counts per pixel
(identified by barcode). If not provided, nUMI will be calculated as the
column sums of the counts matrix.}

\item{use_fake_coords}{logical, whether the 'coords' parameter should be
ignored and replaced with a placeholder coords matrix
(default: \code{FALSE})}

\item{require_int}{logical, whether counts and nUMI are required to be
integers (default: \code{TRUE})}
}
\value{
\code{\linkS4class{SpatialRNA}} object
}
\description{
\code{\linkS4class{SpatialRNA}} object constructor
}
\examples{
data(rctdSim)

spatial_rna <- createSpatialRNA(
    as.data.frame(rctdSim$spatial_rna_coords),
    rctdSim$spatial_rna_counts
)

}
\keyword{internal}
