% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{Reference-class}
\alias{Reference-class}
\alias{show,Reference-method}
\title{RNA-seq reference data}
\usage{
\S4method{show}{Reference}(object)
}
\arguments{
\item{object}{Reference object}
}
\description{
A class representing annotated RNA sequencing data used as a reference to
learn cell type profiles. The reference can come from single-nucleus RNA
sequencing (snRNA-seq), single-cell RNA sequencing (scRNA-seq), or cell
type-specific bulk RNA sequencing. RCTD uses these profiles to estimate cell
type proportions in spatial transcriptomics data.
}
\section{Slots}{

\describe{
\item{\code{cell_types}}{factor vector containing cell type annotations for each cell
in the reference (identified by barcode)}

\item{\code{counts}}{sparse matrix of gene expression counts from RNA-seq data, with
genes as rows and cells as columns (named by cell barcode)}

\item{\code{nUMI}}{numeric vector of total UMI counts per cell (identified by
barcode)}
}}

\examples{
data(rctdSim)

cell_types <- rctdSim$reference_cell_types[["cell_type"]]
names(cell_types) <- rownames(rctdSim$reference_cell_types)
reference <- createReference(rctdSim$reference_counts, cell_types)

}
\keyword{internal}
