% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{findIntensityThreshold}
\alias{findIntensityThreshold}
\title{Estimate the intensity threshold for the reconstruction of spatial structures}
\usage{
findIntensityThreshold(ppp, markSelect = NULL, bndw = NULL, dim, steps = 250)
}
\arguments{
\item{ppp}{point pattern object of class \code{ppp}}

\item{markSelect}{character; name of mark that is to be selected for the
reconstruction}

\item{bndw}{numeric; bandwith of the sigma parameter in the density estimation,
if no value is given the bandwith is estimated using cross validation with
the \code{bw.diggle} function.}

\item{dim}{numeric; x dimension of the final reconstruction.}

\item{steps}{numeric; value used to filter the density estimates, where only
densities greater than the maximum value divided by \code{threshold} are considered.
Default is 250.}
}
\value{
numeric; estimated intensity threshold
}
\description{
Estimate the intensity threshold for the reconstruction of spatial structures
}
\examples{
data(sostaSPE)
ppp <- SPE2ppp(sostaSPE, marks = "cellType", imageCol = "imageName", imageId = "image1")
findIntensityThreshold(ppp, markSelect = "A", dim = 250)
}
