% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_idf_iae_wrappers.R
\name{iae_prob}
\alias{iae_prob}
\title{labeled inverse average expression: probability based}
\usage{
iae_prob(expr, features = NULL, label, multi = TRUE, thres = 0)
}
\arguments{
\item{expr}{a matrix, features in row and cells in column}

\item{features}{vector, feature names or indexes to compute}

\item{label}{vector, group label of each cell}

\item{multi}{logical, if to compute based on binary (FALSE) or multi-class (TRUE)}

\item{thres}{numeric, cell only counts when expr > threshold, default 0}
}
\value{
a matrix of inverse average expression score
}
\description{
labeled inverse average expression: probability based
}
\details{
\deqn{\mathbf{IAE_{i,j}} = log(1+\frac{mean(N_{i,j\in D})}{max(mean(N_{i,j\in \hat D}))+ e^{-8}}*mean(N_{i,j\in D}))}
where \eqn{N_{i,j\in D}} is the counts of feature \eqn{i} in cell \eqn{j}
within class \eqn{D}, and \eqn{\hat D} is the class except \eqn{D}.
}
\examples{
data <- matrix(rpois(100, 2), 10, dimnames = list(1:10))
smartid:::iae_prob(data, label = sample(c("A", "B"), 10, replace = TRUE))
}
