% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_markers.R
\name{markers_mixmdl}
\alias{markers_mixmdl}
\title{select markers using mixtools EM method}
\usage{
markers_mixmdl(
  top_markers,
  column = ".dot",
  prob = 0.99,
  k = 3,
  ratio = 2,
  dist = c("norm", "gamma"),
  maxit = 1e+05,
  plot = FALSE,
  ...
)
}
\arguments{
\item{top_markers}{output of \code{\link[=top_markers]{top_markers()}}}

\item{column}{character, specify which column used as group label}

\item{prob}{numeric, probability cutoff for 1st component classification}

\item{k}{integer, number of components of mixtures}

\item{ratio}{numeric, ratio cutoff of 1st component mu to 2nd component mu,
only when ratio > cutoff will return markers for the group}

\item{dist}{can be one of "norm" and "gamma", specify if to use
\code{\link[mixtools:normalmixEM]{mixtools::normalmixEM()}} or \code{\link[mixtools:gammamixEM]{mixtools::gammamixEM()}}}

\item{maxit}{integer, maximum number of iterations for EM}

\item{plot}{logical, if to plot mixture density and hist}

\item{...}{other params for \code{\link[mixtools:normalmixEM]{mixtools::normalmixEM()}} or \code{\link[mixtools:gammamixEM]{mixtools::gammamixEM()}}}
}
\value{
a list of markers for each group
}
\description{
select markers using mixtools EM method
}
\examples{
set.seed(1000)
data <- matrix(rnorm(100), 10, dimnames = list(1:10))
top_n <- top_markers(data, label = rep(c("A", "B"), 5))
markers_mixmdl(top_n, k = 3)
}
