% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_idf_iae_wrappers.R
\name{idf_m}
\alias{idf_m}
\title{inverse cell frequency: max}
\usage{
idf_m(expr, features = NULL, thres = 0)
}
\arguments{
\item{expr}{a matrix, features in row and cells in column}

\item{features}{vector, feature names or indexes to compute}

\item{thres}{numeric, cell only counts when expr > threshold, default 0}
}
\value{
a matrix of inverse cell frequency score for each feature
}
\description{
inverse cell frequency: max
}
\details{
\deqn{\mathbf{IDF_{i,j}} = log(\frac{max_{\{i^{'}\in j\}}(n_{i^{'}})}{n_i+1})}
where \eqn{i} is the feature \eqn{i} and \eqn{i^{'}} is the feature except
\eqn{i}, \eqn{n_i} is the number of cells containing feature i, and
\eqn{n_{i^{'}}} is the number of cells containing feature \eqn{i^{'}}.
}
\examples{
data <- matrix(rpois(100, 2), 10, dimnames = list(1:10))
smartid:::idf_m(data)
}
