% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seuratFunctions.R
\name{plotSeuratReduction}
\alias{plotSeuratReduction}
\title{plotSeuratReduction
Plots the selected dimensionality reduction method}
\usage{
plotSeuratReduction(
  inSCE,
  useReduction = c("pca", "ica", "tsne", "umap"),
  showLegend = FALSE,
  groupBy = NULL,
  splitBy = NULL
)
}
\arguments{
\item{inSCE}{(sce) object which has the selected dimensionality reduction
algorithm already computed and stored}

\item{useReduction}{Dimentionality reduction to plot. One of "pca", "ica",
"tsne", or "umap". Default \code{"umap"}.}

\item{showLegend}{Select if legends and labels should be shown on the output
plot or not. Either "TRUE" or "FALSE". Default \code{FALSE}.}

\item{groupBy}{Specify a colData column name that be used for grouping.
Default is \code{NULL}.}

\item{splitBy}{Specify a colData column name that be used for splitting the
output plot. Default is \code{NULL}.}
}
\value{
plot object
}
\description{
plotSeuratReduction
Plots the selected dimensionality reduction method
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runSeuratNormalizeData(sce, useAssay = "counts")
sce <- runSeuratFindHVG(sce, useAssay = "counts")
sce <- runSeuratScaleData(sce, useAssay = "counts")
sce <- runSeuratPCA(sce, useAssay = "counts")
plotSeuratReduction(sce, useReduction = "pca")
}
}
