% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importCellRanger.R
\name{importCellRanger}
\alias{importCellRanger}
\alias{importCellRangerV2}
\alias{importCellRangerV3}
\title{Construct SCE object from Cell Ranger output}
\usage{
importCellRanger(
  cellRangerDirs = NULL,
  sampleDirs = NULL,
  sampleNames = NULL,
  cellRangerOuts = NULL,
  dataType = c("filtered", "raw"),
  matrixFileNames = "matrix.mtx.gz",
  featuresFileNames = "features.tsv.gz",
  barcodesFileNames = "barcodes.tsv.gz",
  gzipped = "auto",
  class = c("Matrix", "matrix"),
  delayedArray = FALSE,
  rowNamesDedup = TRUE
)

importCellRangerV2(
  cellRangerDirs = NULL,
  sampleDirs = NULL,
  sampleNames = NULL,
  dataTypeV2 = c("filtered", "raw"),
  class = c("Matrix", "matrix"),
  delayedArray = FALSE,
  reference = NULL,
  cellRangerOutsV2 = NULL,
  rowNamesDedup = TRUE
)

importCellRangerV3(
  cellRangerDirs = NULL,
  sampleDirs = NULL,
  sampleNames = NULL,
  dataType = c("filtered", "raw"),
  class = c("Matrix", "matrix"),
  delayedArray = FALSE,
  rowNamesDedup = TRUE
)
}
\arguments{
\item{cellRangerDirs}{The root directories where Cell Ranger was run. These
folders should contain sample specific folders. Default \code{NULL},
meaning the paths for each sample will be specified in \emph{samples}
argument.}

\item{sampleDirs}{Default \code{NULL}. Can be one of
\itemize{
  \item \code{NULL}. All samples within \code{cellRangerDirs} will be
   imported. The order of samples will be first determined by the order of
   \code{cellRangerDirs} and then by \link{list.dirs}. This is only
   for the case where \code{cellRangerDirs} is specified.
  \item A list of vectors containing the folder names for samples to import.
   Each vector in
   the list corresponds to samples from one of \code{cellRangerDirs}.
   These names are the same as the folder names under \code{cellRangerDirs}.
   This is only for the case where \code{cellRangerDirs} is specified.
  \item A vector of folder paths for the samples to import. This is only for
   the case where \code{cellRangerDirs} is \code{NULL}.
}
The cells in the final SCE object will be ordered in the same order of
 \code{sampleDirs}.}

\item{sampleNames}{A vector of user-defined sample names for the samples
to be
imported. Must have the same length as \code{length(unlist(sampleDirs))} if
\code{sampleDirs} is not \code{NULL}. Otherwise, make sure the length and
order match the output of
\code{unlist(lapply(cellRangerDirs, list.dirs, recursive = FALSE))}. Default
\code{NULL}, in which case the folder names will be used as sample names.}

\item{cellRangerOuts}{Character vector. The intermediate
paths to filtered or raw cell barcode, feature, and matrix files
for each sample. \strong{Supercedes \code{dayaType}}. If \code{NULL},
\code{dataType}
will be used to determine Cell Ranger output directory. If not \code{NULL},
\code{dataType} will be ingored and \code{cellRangerOuts} specifies the
paths. Must have length 1 or the same length as
\code{length(unlist(sampleDirs))} if
\code{sampleDirs} is not \code{NULL}. Otherwise, make sure the length and
order match the output of
\code{unlist(lapply(cellRangerDirs, list.dirs, recursive = FALSE))}.
Reference genome names might need to be
appended for CellRanger version below 3.0.0 if reads were mapped to
multiple genomes when running Cell Ranger pipeline. Probable options
include "outs/filtered_feature_bc_matrix/", "outs/raw_feature_bc_matrix/",
"outs/filtered_gene_bc_matrix/", "outs/raw_gene_bc_matrix/".}

\item{dataType}{Character. The type of data to import. Can be one of
"filtered" (which is equivalent to
\code{cellRangerOuts = "outs/filtered_feature_bc_matrix/"} or
\code{cellRangerOuts = "outs/filtered_gene_bc_matrix/"}) or "raw" (which
is equivalent to
\code{cellRangerOuts = "outs/raw_feature_bc_matrix/"} or
\code{cellRangerOuts = "outs/raw_gene_bc_matrix/"}). Default
"filtered" which imports the counts for filtered cell barcodes only.}

\item{matrixFileNames}{Character vector. Filenames for the Market Exchange
Format (MEX) sparse matrix files (matrix.mtx or matrix.mtx.gz files).
Must have length 1 or the same
length as \code{length(unlist(sampleDirs))} if
\code{sampleDirs} is not \code{NULL}. Otherwise, make sure the length and
order match the output of
\code{unlist(lapply(cellRangerDirs, list.dirs, recursive = FALSE))}.}

\item{featuresFileNames}{Character vector. Filenames for the feature
annotation files. They are usually named \emph{features.tsv.gz} or
\emph{genes.tsv}. Must have length 1 or the same
length as \code{length(unlist(sampleDirs))} if
\code{sampleDirs} is not \code{NULL}. Otherwise, make sure the length and
order match the output of
\code{unlist(lapply(cellRangerDirs, list.dirs, recursive = FALSE))}.}

\item{barcodesFileNames}{Character vector. Filename for the cell barcode
list files. They are usually named \emph{barcodes.tsv.gz} or
\emph{barcodes.tsv}. Must have length 1 or the same
length as \code{length(unlist(sampleDirs))} if
\code{sampleDirs} is not \code{NULL}. Otherwise, make sure the length and
order match the output of
\code{unlist(lapply(cellRangerDirs, list.dirs, recursive = FALSE))}.}

\item{gzipped}{\code{TRUE} if the Cell Ranger output files
(barcodes.tsv, features.tsv, and matrix.mtx) were
gzip compressed. \code{FALSE} otherwise. This is true after Cell Ranger
3.0.0 update. Default \code{"auto"} which automatically detects if the
files are gzip compressed. If not \code{"auto"}, \code{gzipped} must have
length 1 or the same
length as \code{length(unlist(sampleDirs))} if
\code{sampleDirs} is not \code{NULL}. Otherwise, make sure the length and
order match the output of
\code{unlist(lapply(cellRangerDirs, list.dirs, recursive = FALSE))}.}

\item{class}{Character. The class of the expression matrix stored in the SCE
object. Can be one of "Matrix" (as returned by
\link{readMM} function), or "matrix" (as returned by
\link[base]{matrix} function). Default \code{"Matrix"}.}

\item{delayedArray}{Boolean. Whether to read the expression matrix as
\link{DelayedArray} object or not. Default \code{FALSE}.}

\item{rowNamesDedup}{Boolean. Whether to deduplicate rownames. Default 
\code{TRUE}.}

\item{dataTypeV2}{Character. The type of output to import for
Cellranger version below 3.0.0. Whether to import the filtered or the
raw data. Can be one of 'filtered' or 'raw'. Default 'filtered'. When
\code{cellRangerOuts} is specified, \code{dataTypeV2} and \code{reference} will
be ignored.}

\item{reference}{Character vector. The reference genome names.
Default \code{NULL}. If not \code{NULL}, it must gave the length and order as
\code{length(unlist(sampleDirs))} if \code{sampleDirs} is not \code{NULL}.
Otherwise, make sure the length and order match the output of
\code{unlist(lapply(cellRangerDirs, list.dirs, recursive = FALSE))}. Only needed
for Cellranger version below 3.0.0.}

\item{cellRangerOutsV2}{Character vector. The intermediate paths
to filtered or raw cell barcode, feature, and matrix files for each
sample for Cellranger version below 3.0.0. If \code{NULL}, \code{reference} and
\code{dataTypeV2} will be used to determine Cell Ranger output directory. If it has
length 1, it assumes that all samples use the same genome reference and
the function will load only filtered or raw data.}
}
\value{
A \code{SingleCellExperiment} object containing the combined count
 matrix, the feature annotations, and the cell annotation.
}
\description{
Read the filtered barcodes, features, and matrices for all
 samples from (preferably a single run of) Cell Ranger output. Import and
 combine them
 as one big \link[SingleCellExperiment]{SingleCellExperiment} object.
}
\details{
\code{importCellRangerV2} imports output from Cell Ranger V2.
 \code{importCellRangerV2Sample} imports output from one sample from Cell
 Ranger V2.
 \code{importCellRangerV3} imports output from Cell Ranger V3.
 \code{importCellRangerV3} imports output from one sample from Cell Ranger
 V3.
 Some implicit
 assumptions which match the output structure of Cell Ranger V2 & V3
 are made in these 4 functions including \code{cellRangerOuts},
 \code{matrixFileName}, \code{featuresFileName}, \code{barcodesFileName},
 and \code{gzipped}.
 Alternatively, user can call \code{importCellRanger} to explicitly
 specify these arguments.
}
\examples{
# Example #1
# The following filtered feature, cell, and matrix files were downloaded from
# https://support.10xgenomics.com/single-cell-gene-expression/datasets/
# 3.0.0/hgmm_1k_v3
# The top 10 hg19 & mm10 genes are included in this example.
# Only the first 20 cells are included.
sce <- importCellRanger(
    cellRangerDirs = system.file("extdata/", package = "singleCellTK"),
    sampleDirs = "hgmm_1k_v3_20x20",
    sampleNames = "hgmm1kv3",
    dataType = "filtered")
# The following filtered feature, cell, and matrix files were downloaded from
# https://support.10xgenomics.com/single-cell-gene-expression/datasets/
# 2.1.0/pbmc4k
# Top 20 genes are kept. 20 cell barcodes are extracted.
sce <- importCellRangerV2(
    cellRangerDirs = system.file("extdata/", package = "singleCellTK"),
    sampleDirs = "pbmc_4k_v2_20x20",
    sampleNames = "pbmc4k_20",
    reference = 'GRCh38',
    dataTypeV2 = "filtered")
sce <- importCellRangerV3(
    cellRangerDirs = system.file("extdata/", package = "singleCellTK"),
    sampleDirs = "hgmm_1k_v3_20x20",
    sampleNames = "hgmm1kv3",
    dataType = "filtered")
}
