% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{difference_score}
\alias{difference_score}
\title{Difference score}
\usage{
difference_score(mat, cl)
}
\arguments{
\item{mat}{The similarity matrix.}

\item{cl}{Cluster labels.}
}
\value{
A numeric scalar.
}
\description{
Difference score
}
\details{
This function measures the different between the similarity values for the terms
that belong to the same clusters and in different clusters. The difference score
is the Kolmogorov-Smirnov statistic between the two distributions.
}
\examples{
mat = readRDS(system.file("extdata", "random_GO_BP_sim_mat.rds", 
    package = "simplifyEnrichment"))
cl = binary_cut(mat)
difference_score(mat, cl)
}
