% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeCells.R
\name{normalizeCells}
\alias{normalizeCells}
\title{Normalizes and transforms cell data in preparation for clustering
(accepts dataframe, SingleCellExperiment and SpatialExperiment).}
\usage{
normalizeCells(
  cells,
  markers = NULL,
  assayIn = NULL,
  assayOut = "norm",
  imageID = "imageID",
  transformation = NULL,
  method = NULL,
  cores = 1
)
}
\arguments{
\item{cells}{A Dataframe of SingleCellExperiment or SpatialExperiment
containing cells and features to be normalized/transformed}

\item{markers}{A list containing the names of cell markers which will be
normalized and/or transformed.}

\item{assayIn}{If input is a SingleCellExperiment or SpatialExperiment with
multiple assays, specify the assay to be normalized and/or
transformed.}

\item{assayOut}{If input is a SingleCellExperiment or SpatialExperiment, the
new of the normalized data.}

\item{imageID}{If input is a SingleCellExperiment or SpatialExperiment, this
is the name of the image ID variable in order to stratify.
cells correctly}

\item{transformation}{The transformation/s to be performed, default is NULL,
accepted values: 'asinh' and 'sqrt'.}

\item{method}{The normalization method/s to be performed, default is NULL,
accepted values: 'mean', 'minMax', 'trim99', 'PC1'.}

\item{cores}{The number or cores for parallel processing.}
}
\value{
returns a dataframe with individual cells as rows and features as
        columns.
}
\description{
Normalizes and transforms cell data in preparation for clustering
(accepts dataframe, SingleCellExperiment and SpatialExperiment).
}
\examples{

library(cytomapper)
data("pancreasSCE")
cells.normalized <- normalizeCells(
  cells = pancreasSCE,
  markers = c("CD99", "PIN", "CD8a", "CDH"),
  assayIn = "counts",
  assayOut = "normCounts",
  imageID = "ImageNb",
  transformation = "asinh",
  method = "trim99"
)

}
