% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_ancestor.R
\name{MICA_term}
\alias{MICA_term}
\alias{MICA_IC}
\alias{LCA_term}
\alias{LCA_depth}
\alias{NCA_term}
\alias{max_ancestor_v}
\alias{max_ancestor_id}
\alias{max_ancestor_path_sum}
\alias{CA_terms}
\title{Various types of common ancestors}
\usage{
MICA_term(
  dag,
  terms,
  IC_method,
  in_labels = TRUE,
  distance = "longest",
  verbose = simona_opt$verbose
)

MICA_IC(dag, terms, IC_method, verbose = simona_opt$verbose)

LCA_term(
  dag,
  terms,
  in_labels = TRUE,
  distance = "longest",
  verbose = simona_opt$verbose
)

LCA_depth(dag, terms, verbose = simona_opt$verbose)

NCA_term(dag, terms, in_labels = TRUE, verbose = simona_opt$verbose)

max_ancestor_v(dag, terms, value, verbose = simona_opt$verbose)

max_ancestor_id(
  dag,
  terms,
  value,
  in_labels = FALSE,
  distance = "longest",
  verbose = simona_opt$verbose
)

max_ancestor_path_sum(
  dag,
  terms,
  value,
  add_v,
  distance = "longest",
  verbose = simona_opt$verbose
)

CA_terms(dag, term1, term2, in_labels = TRUE)
}
\arguments{
\item{dag}{An \code{ontology_DAG} object.}

\item{terms}{A vector of term names.}

\item{IC_method}{An IC method. Valid values are in \code{\link[=all_term_IC_methods]{all_term_IC_methods()}}.}

\item{in_labels}{Whether the terms are represented in their names or as integer indices?}

\item{distance}{If there are multiple LCA or MICA of two terms, whether to take the one with
the longest distance of shortest distance to the two terms. Possible values are "longest" and "shortest".}

\item{verbose}{Whether to print messages.}

\item{value}{A numeric vector. The elements should corrrespond to terms in \code{dag_all_terms()} (should have the same length as the number of terms in the DAG).}

\item{add_v}{Values to be added along the path to the MICA or LCA. The same format as \code{value}.}

\item{term1}{A single term ID.}

\item{term2}{A single term ID.}
}
\value{
\itemize{
\item \code{MICA_term()} returns an integer or a character matrix of the MICA terms depending on the value of \code{in_labels}.
\item \code{MICA_IC()} returns a numeric matrix of the IC of the MICA terms.
\item \code{LCA_term()} returns an integer or a character matrix of the LCA term depending on the value of \code{in_labels}.
\item \code{LCA_depth()} returns an integer matrix of the depth of the LCA terms.
\item \code{NCA_term()} returns an integer or a character matrix of the NCA term depending on the value of \code{in_labels}. The shortest distance from NCA terms can be calculated by \code{\link[=shortest_distances_via_NCA]{shortest_distances_via_NCA()}}.
\item \code{max_ancestor_v()} returns a numeric matrix.
\item \code{max_ancestor_id()} returns an integer or a character matrix.
\item \code{CA_terms()} returns a vector of term IDs.
}
}
\description{
Various types of common ancestors
}
\details{
There are the following three types of common ancestors:
\itemize{
\item MICA (most informative common ancestor): The common ancestor with the highest IC value.
\item LCA (lowest common ancestor): The common ancestor with the largest depth (The depth of a term is the maximal distance from the root term). If there are multiple ancestors having
the same max depth, the ancestor with the smallest distance to the two terms is used.
\item NCA (nearest common ancestor): The common ancestor with the smallest distance to the two terms. If there are multiple
ancestors with the same smallest distance, the ancestor with the largest depth is used.
}

\code{max_ancestor_v()} and \code{max_ancestor_id()} are more general functions which return common ancestors with
the highest value in \code{value}.

Given a path connecting two terms and their MICA/LCA, \code{max_ancestor_path_sum()} calculates the sum of terms along the path. The values
to be added in specified in \code{add_v} argument.
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
dag = create_ontology_DAG(parents, children)
MICA_term(dag, letters[1:6], "IC_universal")
MICA_IC(dag, letters[1:6], "IC_universal")
LCA_term(dag, letters[1:6])
LCA_depth(dag, letters[1:6])
NCA_term(dag, letters[1:6])
CA_terms(dag, "c", "d")
}
