% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.R
\name{random_terms}
\alias{random_terms}
\alias{random_items}
\title{Randomly sample terms/items}
\usage{
random_terms(dag, n)

random_items(dag, n)
}
\arguments{
\item{dag}{An \code{ontology_DAG} object.}

\item{n}{Number of terms or items.}
}
\value{
A character vector of terms or items.
}
\description{
Randomly sample terms/items
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
annotation = list(
    "a" = c("t1", "t2", "t3"),
    "b" = c("t3", "t4"),
    "c" = "t5",
    "d" = "t7",
    "e" = c("t4", "t5", "t6", "t7"),
    "f" = "t8"
)
dag = create_ontology_DAG(parents, children, annotation = annotation)
random_terms(dag, 3)
random_items(dag, 3)
}
