% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricsMethods.R
\name{ratioIntersectMethod}
\alias{ratioIntersectMethod}
\title{Ratio between the intersection area of two profiles and the 
total area covered by those profiles}
\usage{
ratioIntersectMethod(profile1, profile2, threshold = 1)
}
\arguments{
\item{profile1}{a \code{vector} of \code{numeric} values, the first profile
containing the alignment depth for each position. The \code{profile1} and 
\code{profile2} should have the same length.}

\item{profile2}{a \code{vector} of \code{numeric} values, the second profile
containing the alignment depth for each position. The \code{profile1} and 
\code{profile2} should have the same length.}

\item{threshold}{a \code{numeric}, the minimum total area value accepted 
to calculate a ratio.}
}
\value{
The calculated ratio or \code{NA} if the total area is inferior 
to the threshold.
}
\description{
Calculate and return the ratio between the intersection area 
of two profiles and the total area covered by those profiles. If the total
area is inferior to 
the threshold, the function returns \code{NA}.
}
\seealso{
\itemize{
\item \code{\link{MetricFactory}} {for using the recommanded interface to 
calculate all available metrics separately or togheter.}
}
}
\author{
Astrid Deschenes, Elsa Bernatchez
}
