% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPICsimulate.R
\name{simPICsimulate}
\alias{simPICsimulate}
\alias{simPICsimulatesingle}
\alias{simPICsimulatemulti}
\title{simPIC simulation}
\usage{
simPICsimulate(
  object = newsimPICcount(),
  pm.distr = "weibull",
  method = c("single", "groups"),
  verbose = TRUE,
  ...
)

simPICsimulatesingle(object = newsimPICcount(), verbose = TRUE, ...)

simPICsimulatemulti(
  object = newsimPICcount(),
  pm.distr = "weibull",
  method = c("groups"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{simPICcount object with simulation parameters.
See \code{\link{simPICcount}} for details.}

\item{pm.distr}{distribution parameter for peak means.
Available distributions: gamma, weibull, lngamma, pareto.
Default is weibull.}

\item{method}{to use for simulation. Single for simulating one cell-type or
groups for simulating distinct cell-types.}

\item{verbose}{logical variable. Prints the simulation progress if TRUE.}

\item{...}{Any additional parameter settings to override what is provided
in \code{simPICcount} object.}
}
\value{
SingleCellExperiment object containing the simulated counts.
}
\description{
Simulate peak by cell count matrix from a sparse single-cell ATAC-seq
peak by cell input using simPIC methods.
}
\details{
simPIC provides the option to manually adjust each of the
\code{simPICcount} object parameters by calling
\code{\link{setsimPICparameters}}.

 The simulation involves following steps:
 \enumerate{
 \item Set up simulation parameters
 \item Set up SingleCellExperiment object
 \item Simulate library sizes
 \item Simulate sparsity
 \item Simulate peak means
 \item Create final synthetic counts
 }

The final output is a
\code{\link[SingleCellExperiment]{SingleCellExperiment}} object that
contains the simulated count matrix. The parameters are stored in the
\code{\link[SummarizedExperiment]{colData}} (for cell specific information),
\code{\link[SummarizedExperiment]{rowData}} (for peak specific information) or
\code{\link[SummarizedExperiment]{assays}} (for peak by cell matrix) slots. This additional
information includes:
}
\examples{
# default simulation
sim <- simPICsimulate(pm.distr = "weibull")
}
