% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{gmt2h5}
\alias{gmt2h5}
\title{Convert GMT to HDF5 File}
\usage{
gmt2h5(gmtfile, dest_h5, by_nset = 5000, overwrite = FALSE)
}
\arguments{
\item{gmtfile}{character(1), path to gmt file containing gene sets}

\item{dest_h5}{character(1), path of the hdf5 destination file}

\item{by_nset}{number of gene sets to import in each iteration to limit 
memory usage}

\item{overwrite}{TRUE or FALSE, whether to overwrite or to append to 
existing 'h5file'}
}
\value{
HDF5 file
}
\description{
Read gene sets from large gmt file in batches, convert the gene sets to
01 matrix and write the result to an HDF5 file.
}
\examples{
gmt <- system.file("extdata", "test_gene_sets_n4.gmt", 
        package="signatureSearch")
h5file <- tempfile(fileext=".h5")
gmt2h5(gmtfile=gmt, dest_h5=h5file, overwrite=TRUE)
}
