% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gess_res_summary.R
\name{drug_cell_ranks}
\alias{drug_cell_ranks}
\title{Summary ranking statistics across cell types}
\usage{
drug_cell_ranks(gessResult)
}
\arguments{
\item{gessResult}{`gessResult` object}
}
\value{
data.frame
}
\description{
The \code{drug_cell_ranks} function returns from a \code{gessResult} object 
the ranks of the perturbagens (e.g. drugs) for each cell type. The results 
are arranged in separate columns of a \code{data.frame}. Additionally, it 
includes in the last columns summary ranking statistics across all cell 
types, such as min, mean and max values.
}
\examples{
gr <- gessResult(result=dplyr::tibble(pert=c("p1", "p1", "p2", "p3"),
                                      cell=c("MCF7", "SKB", "MCF7", "SKB"),
                                      type=rep("trt_cp", 4),
                                      NCS=c(1.2, 1, 0.9, 0.6)),
                 query=list(up="a", down="b"), 
                 gess_method="LINCS", refdb="path/to/refdb")
df <- drug_cell_ranks(gr)
}
