% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_fea_res.R
\name{comp_fea_res}
\alias{comp_fea_res}
\title{Plot for Comparing Ranking Results of FEA Methods}
\usage{
comp_fea_res(
  table_list,
  rank_stat = "pvalue",
  Nshow = 20,
  Nchar = 50,
  scien = FALSE,
  ...
)
}
\arguments{
\item{table_list}{a named list of tibbles extracted from feaResult objects,
e.g. generated with different FEA methods.}

\item{rank_stat}{character(1), column name of the enrichment statisic used 
for ranking the functional categories, e.g. 'pvalue' or 'p.adjust'. Note,
the chosen column name needs to be present in each tibble of 'table_list'.}

\item{Nshow}{integer defining the number of the top functional categories 
to display in the plot after re-ranking them across FEA methods}

\item{Nchar}{integer defining number of characters displayed (exceeded 
characters were replaced by '...') in the description of each item}

\item{scien}{TRUE or FALSE, indicating whether the rank_stat is rounded to
the scientific format with 3 digits}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{geom_point}}}
}
\value{
ggplot2 graphics object
}
\description{
Dot plot for comparing the top ranking functional categories from different 
functional enrichment analysis (FEA) results. The functional categories are 
plotted in the order defined by their mean rank across the corresponding 
FEA results.
}
\details{
The `comp_fea_res` function computes the mean rank for each functional 
category across different FEA result instances and then re-ranks them based 
on that. Since the functional categories are not always present in all 
enrichment results, the mean rank of a functional category is corrected by 
an adjustment factor that is the number of enrichment result methods used 
divided by the number of occurences of a functional category. For instance, 
if a functional category is only present in the result of one method, its 
mean rank will be increased accordingly. Subsequently, the re-ranked 
functional categories are compared in a dot plot where the colors represent 
the values of the enrichment statistic chosen under the \code{rank_stat} 
argument.
}
\examples{
method1 <- data.frame("ID"=paste0("GO:", 1:5), 
                      "Description"=paste0("desc", 1:5),
                      "pvalue"=c(0.0001, 0.002, 0.004, 0.01, 0.05))
method2 <- data.frame("ID"=paste0("GO:", c(1,3,5,4,6)), 
                      "Description"=paste0("desc", c(1,3,5,4,6)),
                      "pvalue"=c(0.0003, 0.0007, 0.003, 0.006, 0.04))
table_list <- list("method1" = method1, "method2"=method2) 
comp_fea_res(table_list, rank_stat="pvalue", Nshow=20)
}
