% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-utils.R
\name{input_matrix}
\alias{input_matrix}
\alias{output_matrix}
\title{Get input/output matrix out of JSON CWL file directly}
\usage{
input_matrix(
  from,
  new.order = c("id", "label", "type", "required", "prefix", "fileTypes"),
  required = NULL
)

output_matrix(from, new.order = c("id", "label", "type", "fileTypes"))
}
\arguments{
\item{from}{JSON file path}

\item{new.order}{a vector of column orders by default for input it's
\code{"id"}, \code{"label"}, \code{"type"}, \code{"required"},
\code{"prefix"}, \code{"fileTypes"}; For output it's
\code{"id"}, \code{"label"}, \code{"type"}, \code{"fileTypes"}}

\item{required}{logical value, show requried input node only or not.}
}
\value{
A data frame of input/output information.
}
\description{
An efficient way to access JSON file, no need to convert a JSON into a
\code{Tool} or \code{Flow} object before access, directly operate on a
list parsed from JSON file. Compare to \code{convert_app}, it is much faster.
}
\examples{
tool.in <- system.file("extdata/app", "tool_unpack_fastq.json", package = "sevenbridges")
flow.in <- system.file("extdata/app", "flow_star.json", package = "sevenbridges")
input_matrix(tool.in)
input_matrix(tool.in, required = TRUE)
input_matrix(flow.in)
input_matrix(flow.in, c("id", "type"))
input_matrix(flow.in, required = TRUE)
tool.in <- system.file("extdata/app", "tool_unpack_fastq.json", package = "sevenbridges")
flow.in <- system.file("extdata/app", "flow_star.json", package = "sevenbridges")
output_matrix(tool.in)
output_matrix(flow.in)
}
