% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-cwl.R
\docType{class}
\name{Process-class}
\alias{Process-class}
\alias{Process}
\title{Process Class}
\description{
The base executable type in CWL is the Process object defined by
the document. Note that the Process object is abstract and cannot
be directly executed.
}
\section{Fields}{

\describe{
\item{\code{id}}{[character] The unique identifier for this process
object.}

\item{\code{inputs}}{(InputParameterList) Defines the input parameters of
the process. The process is ready to run when all required input
parameters are associated with concrete values. Input parameters
include a schema for each parameter and is used to validate the
input object, it may also be used build a user interface for
constructing the input object.}

\item{\code{outputs}}{(OutputParameterList) Defines the parameters
representing the output of the process. May be used to generate
and/or validate the output object.}

\item{\code{requirements}}{[ProcessRequirementList] Declares requirements
that apply to either the runtime environment or the workflow engine
that must be met in order to execute this process. If an
implementation cannot satisfy all requirements, or a requirement is
listed which is not recognized by the implementation, it is a fatal
error and the implementation must not attempt to run the process,
unless overridden at user option.}

\item{\code{hints}}{[ANY] Declares hints applying to either the runtime
environment or the workflow engine that may be helpful in executing
this process. It is not an error if an implementation cannot
satisfy all hints, however the implementation may report a warning.}

\item{\code{label}}{[character] A short, human-readable label of this
process object.}

\item{\code{description}}{[character] A long, human-readable description
of this process object.}
}}


\examples{
ipl <- InputParameterList(
  InputParameter(
    id = "BAM", type = "File",
    label = "input bam",
    description = "input bam",
    inputBinding = CommandLineBinding(
      position = 1L
    )
  ),
  InputParameter(
    id = "level", type = "Integer",
    label = "Compression level",
    description = "Compression level",
    inputBinding = CommandLineBinding(
      position = 2L,
      prefix = "-l"
    )
  )
)
ipl
p <- Process(id = "process", inputs = ipl)
p
}
