% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-flow.R
\docType{class}
\name{SBGWorkflow-class}
\alias{SBGWorkflow-class}
\alias{SBGWorkflow}
\alias{Flow}
\alias{+,Tool,Tool-method}
\alias{"+",Tool,Tool-method}
\alias{+,WorkflowStepList,Tool-method}
\alias{"+",WorkflowStepList,Tool-method}
\alias{+,WorkflowStepList,WorkflowStepList-method}
\alias{"+",WorkflowStepList,WorkflowStepList-method}
\alias{+,App,App-method}
\alias{"+",App,App-method}
\alias{+,WorkflowStepList,App-method}
\alias{"+",WorkflowStepList,App-method}
\alias{\%>>\%}
\alias{"\%>>\%"}
\alias{\%>>\%,Tool,Tool-method}
\alias{"\%>>\%",Tool,Tool-method}
\alias{\%>>\%,Workflow,Tool-method}
\alias{"\%>>\%",Workflow,Tool-method}
\alias{\%>>\%,Workflow,Workflow-method}
\alias{"\%>>\%",Workflow,Workflow-method}
\alias{\%>>\%,App,App-method}
\alias{"\%>>\%",App,App-method}
\alias{\%>>\%,Workflow,App-method}
\alias{"\%>>\%",Workflow,App-method}
\title{Build workflow}
\usage{
Flow(
  ...,
  graph = TRUE,
  x.width = 1000,
  y.width = 400,
  x.start = 100,
  y.start = 200,
  canvas_zoom = 1,
  canvas_x = 40,
  canvas_y = 130
)

\S4method{+}{Tool,Tool}(e1, e2)

\S4method{+}{WorkflowStepList,Tool}(e1, e2)

\S4method{+}{WorkflowStepList,WorkflowStepList}(e1, e2)

\S4method{+}{App,App}(e1, e2)

\S4method{+}{WorkflowStepList,App}(e1, e2)

e1 \%>>\% e2

\S4method{\%>>\%}{Tool,Tool}(e1, e2)

\S4method{\%>>\%}{Workflow,Tool}(e1, e2)

\S4method{\%>>\%}{Workflow,Workflow}(e1, e2)

\S4method{\%>>\%}{App,App}(e1, e2)

\S4method{\%>>\%}{Workflow,App}(e1, e2)
}
\arguments{
\item{...}{extra arguments passed to SBGWorkflow}

\item{graph}{if add graph coordinates or not,
used for flow visualization on Seven Bridges platforms.}

\item{x.width}{x scale width}

\item{y.width}{y scale width}

\item{x.start}{node x start point for a flow}

\item{y.start}{node y start point for a flow}

\item{canvas_zoom}{zoom factor}

\item{canvas_x}{canvas x}

\item{canvas_y}{canvas y}

\item{e1}{either Tool App or Workflow object}

\item{e2}{either Tool App or Workflow object}
}
\value{
a SBGWorkflow object.
}
\description{
Build workflow
}
\section{Methods}{

\describe{
\item{\code{copy_obj()}}{this is a hack to make copy of reference cwl object}

\item{\code{get_input(ids, force = FALSE)}}{get input by pure input id from all steps}

\item{\code{get_input_exposed()}}{exposed input id other than file}

\item{\code{get_input_node()}}{get input file nodes id}

\item{\code{get_input_port()}}{show included port of all inputs}

\item{\code{get_output(ids, force = FALSE)}}{get output by pure output id from all steps}

\item{\code{get_output_node()}}{get output file nodes id}

\item{\code{get_required()}}{show flow required input id and types}

\item{\code{get_step(name = NULL, id = NULL)}}{get step object by name or id, name support pattern match}

\item{\code{get_tool(name = NULL, id = NULL)}}{get a tool object by name or id, name support pattern match}

\item{\code{input_id()}}{show input id}

\item{\code{input_matrix(
  new.order = c("id", "label", "type", "required", "prefix", "fileTypes"),
  required = NULL
)}}{This return a matrix of input parameters, by default, following the order id, label, type, required, prefix, fileTypes. new.order accept names of column you want to print, but it has to be a field of inputs. When its set to NULL, it prints all fields. When required = TRUE, only print required field.}

\item{\code{input_type()}}{Show a vector of flow input type, names of them are input id.}

\item{\code{link_map()}}{show a table of all linked nodes}

\item{\code{linked_input_id()}}{input id that linked to an output}

\item{\code{linked_output_id()}}{output id that linked to an input}

\item{\code{list_tool()}}{list all tools included in this flow}

\item{\code{output_id()}}{show output id}

\item{\code{output_matrix(new.order = c("id", "label", "type", "fileTypes"))}}{This return a matrix of output parameters, by default, following the order id, label, type, fileTypes. new.order accept names of column you want to print, but it has to be a field of outputs. When its set to NULL, it prints all fields. When required = TRUE, only print required field.}

\item{\code{output_type()}}{Show a vector of flow output type, names of them are output id.}

\item{\code{run(run_inputs = list(), engine = c("bunny", "rabix", "cwlrun"))}}{Run this tool with inputs locally. Engines supported: bunny, rabix, cwlrun. Inputs accept list or JSON.}

\item{\code{set_batch(input = NULL, criteria = NULL, type = c("ITEM", "CRITERIA"))}}{Set a flow input node into a batch mode, this is now required before you execute a batch task on a batch-not-enabled flow.}

\item{\code{set_flow_input(iid = NULL, add = TRUE)}}{Expose tool input node as flow input, default is additative, if add = FALSE, this will overwrite and only made provided id inputs of flow.}

\item{\code{set_flow_output(oid = NULL, add = TRUE)}}{Expose tool output node as flow output, default is additative, if add = FALSE, this will overwrite and only made provided id outputs of flow.}

\item{\code{set_input_port(ids, include = TRUE)}}{set included port for provided input id(s)}

\item{\code{set_required(ids, required = TRUE)}}{Set a input node required (TRUE) or not required (FALSE) this require full input id (with tool id prefix) such as #STAR.alignIntronMax}

\item{\code{step_input_id(full = FALSE)}}{Show step input id, default names of them is tool id. When full = TRUE, show full name then names of vector is type.}

\item{\code{step_output_id(full = FALSE)}}{Show step output id, default names of them is tool id. when full = TRUE, show full name then names of vector is type.}
}}

\examples{
f1 <- system.file("extdata/app", "flow_star.json", package = "sevenbridges")
f1 <- convert_app(f1)
# input matrix
f1$input_matrix()
# by name
f1$input_matrix(c("id", "type", "required", "link_to"))
# return only required
f1$input_matrix(required = TRUE)
# return everything
f1$input_matrix(NULL)
# return a output matrix with more informtion
f1$output_matrix()
# return only a few fields
f1$output_matrix(c("id", "type"))
# return everything
f1$output_matrix(NULL)
# flow inputs
f1$input_type()
# flow outouts
f1$output_type()
# flow input id
f1$input_id()
# linked input id
f1$linked_input_id()
# flow output id
f1$output_id()
# linked output id
f1$linked_output_id()
# link_map
f1$link_map()
# all step input id
f1$step_input_id()
# all step input full id with type
f1$step_input_id(TRUE)
# all step output id
f1$step_output_id()
# all step output full id with type
f1$step_output_id(TRUE)
# get inputs objects
f1$get_input("#clip3pNbases")
f1$get_input(c("#clip3pNbases", "#chimScoreMin"))
f1$get_input(c("#clip3pNbases", "#chimScoreMin", "#STAR.outFilterMismatchNoverLmax"))
# get outputs objects
f1$get_output("#log_files")
f1$get_output(c("#log_files", "intermediate_genome"))
f1$get_output(c("#log_files", "intermediate_genome", "#STAR.unmapped_reads"))
f1$get_output("#log_files")
# set flow input
f1$set_flow_input("#SBG_FASTQ_Quality_Detector.fastq")
f1$set_flow_output(c("#log_files", "intermediate_genome"))
# get required node
f1$get_required()
# set required node
f1$steps[[1]]$run$set_required("genomeChrBinNbits")
f1$get_required()
f1$steps[[1]]$run$set_required("genomeChrBinNbits", FALSE)
f1$get_required()
# get Tool object from Flow by id and name
f1$list_tool()
# return two
f1$get_tool("STAR")
# return one
f1$get_tool("^STAR$")
# get included input ports
f1$get_input_port()
# set included input ports
f1$set_input_port(c("#STAR.alignSJDBoverhangMin", "chimScoreSeparation"))
f1$get_input_port()
f1$set_input_port(c("#STAR.alignSJDBoverhangMin", "chimScoreSeparation"), FALSE)
f1$get_input_port()
f1$get_input_node()
f1$get_output_node()
f1$get_input_exposed()
f1$step_input_id(TRUE)
f1$input_id()
f1$set_flow_input("#STAR.reads")
f1$input_id()
# batch
f1$set_batch("sjdbGTFfile", c("metadata.sample_id", "metadata.library_id"))
f1$set_batch("sjdbGTFfile", type = "ITEM")
# add source to id
f1$link_map()
f1$add_source_to_id(c("test1", "test2"), c("#STAR.genome", "#STAR.reads"))
f1$link_map()
}
