% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{prepareCisPairs}
\alias{prepareCisPairs}
\title{Prepares motif pairs as \code{\link[InteractionSet:InteractionSet-class]{GInteractions}} and add
genomic features.}
\usage{
prepareCisPairs(motifs, maxDist = 1e+06, scoreColname = "score")
}
\arguments{
\item{motifs}{\code{\link[GenomicRanges:GRanges-class]{GRanges}} object with motif
locations.}

\item{maxDist}{maximal distance in base-pairs between pairs of ranges as
single  numeric value.}

\item{scoreColname}{Character as name the metadata column in with motif
score.}
}
\value{
An \code{\link[InteractionSet:GInteractions-class]{GInteractions}} object with motif
  pairs and annotations of distance, strand orientation, and motif scores.
}
\description{
Prepares motif pairs as \code{\link[InteractionSet:InteractionSet-class]{GInteractions}} and add
genomic features.
}
\examples{

# build example GRanges as anchors
anchorGR <- GRanges(
 rep("chr1", 4),
 IRanges(
   c(1, 5, 20, 14),
   c(4, 8, 23, 17)
 ),
 strand = c("+", "+", "+", "-"),
 score = c(5, 4, 6, 7)
)



# prepare candidates
gi <- prepareCisPairs(anchorGR)


# prepare candidates using a mimial distance of 10 bp
gi <- prepareCisPairs(anchorGR, maxDist = 10)

# prepare candidates using an alternative score value in anchors
anchorGR$myScore <- rnorm(length(anchorGR))
gi <- prepareCisPairs(anchorGR, scoreColname = "myScore")

}
