% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{addCor}
\alias{addCor}
\title{Add correlation of ChIP-seq coverage to motif pairs.}
\usage{
addCor(gi, bwFile, name = "chip", window = 1000, binSize = 1)
}
\arguments{
\item{gi}{\code{\link[InteractionSet:GInteractions-class]{GInteractions}} object.}

\item{bwFile}{File path or connection to BigWig file with ChIP-seq signals.}

\item{name}{Character indicating the sample name.}

\item{window}{Numeric scalar for window size around the center of ranges in
\code{gr}.}

\item{binSize}{Integer scalar as size of bins to which the coverage values are
combined.}
}
\value{
An \code{\link[InteractionSet:InteractionSet-class]{GInteractions}} object like \code{gi}
 with a new metadata column \code{colname} holding Pearson correlation
 coefficient of ChIP-seq signals for each anchor pair.
}
\description{
This function first adds ChIP-seq signals along all regions of motif location
using the function \code{\link{addCovToGR}}. Than it calculates the
correlation of coverage for each input pair using the function
\code{\link{addCovCor}}. The Pearson correlation coefficient is added as new
metadata column to the input interactions. Note, this function does not work
on windows because reading of bigWig files is currently not supported on
windows.
}
\examples{
if (.Platform$OS.type != "windows") {

 # use example bigWig file of ChIP-seq signals on human chromosome 22
 exampleBigWig <- system.file("extdata",
 "GM12878_Stat1.chr22_1-30000000.bigWig", package = "sevenC")

 # use example CTCF moitf location on human chromosome 22
 motifGR <- sevenC::motif.hg19.CTCF.chr22

 # build candidate interactions
 gi <- prepareCisPairs(motifGR)


 # add ChIP-seq signals correlation
 gi <- addCor(gi, exampleBigWig)

 # use an alternative metadata column name for ChIP-seq correlation
 gi <- addCor(gi, exampleBigWig, name = "Stat1")


 # add ChIP-seq correlation for signals signals in windows of 500bp around
 # motif centers
 gi <- addCor(gi, exampleBigWig, window = 500)


 # add ChIP-seq correlation for signals in bins of 10 bp
 gi <- addCor(gi, exampleBigWig, binSize = 10)

}
}
