% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesame.R
\docType{package}
\name{sesame-package}
\alias{sesame-package}
\alias{sesame}
\title{Analyze DNA methylation data}
\value{
package
}
\description{
SEnsible and step-wise analysis of DNA methylation data
}
\details{
This package complements array functionalities that allow
processing >10,000 samples in parallel on clusters.
}
\examples{

sdf <- readIDATpair(sub('_Grn.idat','',system.file(
    'extdata','4207113116_A_Grn.idat',package='sesameData')))

## The OpenSesame pipeline
betas <- openSesame(sdf)

}
\references{
Zhou W, Triche TJ, Laird PW, Shen H (2018)
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/zwdzwd/sesame}
  \item Report bugs at \url{https://github.com/zwdzwd/sesame/issues}
}

}
\author{
Wanding Zhou \email{Wanding.Zhou@vai.org},
Hui Shen \email{Hui.Shen@vai.org}
Timothy J Triche Jr \email{Tim.Triche@vai.org}
}
\keyword{DNAMethylation}
\keyword{Microarray}
\keyword{QualityControl}
