% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesame.R
\name{readIDATpair}
\alias{readIDATpair}
\title{Import a pair of IDATs from one sample}
\usage{
readIDATpair(
  prefix.path,
  manifest = NULL,
  platform = "",
  min_beads = NULL,
  controls = NULL,
  verbose = FALSE
)
}
\arguments{
\item{prefix.path}{sample prefix without _Grn.idat and _Red.idat}

\item{manifest}{optional design manifest file}

\item{platform}{EPIC, HM450 and HM27 etc.}

\item{min_beads}{minimum bead number, probes with R or G smaller than
this threshold will be masked. If NULL, no filtering based on bead
count will be applied.}

\item{controls}{optional control probe manifest file}

\item{verbose}{be verbose?  (FALSE)}
}
\value{
a \code{SigDF}
}
\description{
The function takes a prefix string that are shared with _Grn.idat
and _Red.idat. The function returns a \code{SigDF}.
}
\examples{
sdf <- readIDATpair(sub('_Grn.idat','',system.file(
    "extdata", "4207113116_A_Grn.idat", package = "sesameData")))
}
