% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileSet.R
\name{readFileSet}
\alias{readFileSet}
\title{Read an existing fileSet from storage}
\usage{
readFileSet(map_path)
}
\arguments{
\item{map_path}{path of file to map (should contain valid _idx.rds index)}
}
\value{
a sesame::fileSet object
}
\description{
This function only reads the meta-data.
}
\examples{

## create two samples
fset <- initFileSet('mybetas2', 'HM27', c('s1','s2'))

## a hypothetical numeric array (can be beta values, intensities etc)
hypothetical <- setNames(runif(fset$n), fset$probes)

## map the numeric to file
mapFileSet(fset, 's1', hypothetical)

## read it from file
fset <- readFileSet('mybetas2')

## get data
sliceFileSet(fset, 's1', 'cg00000292')

}
