% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{createUCSCtrack}
\alias{createUCSCtrack}
\title{Turn beta values into a UCSC browser track}
\usage{
createUCSCtrack(betas, output = NULL, platform = "HM450", genome = "hg38")
}
\arguments{
\item{betas}{a named numeric vector}

\item{output}{output file name}

\item{platform}{HM450, EPIC etc.}

\item{genome}{hg38, mm10, ..., will infer if not given.
For additional mapping, download the GRanges object from
http://zwdzwd.github.io/InfiniumAnnotation
and provide the following argument
..., genome = sesameAnno_buildManifestGRanges("downloaded_file"),...
to this function.}
}
\value{
when output is null, return a data.frame, otherwise NULL
}
\description{
Turn beta values into a UCSC browser track
}
\examples{

betas.tissue <- sesameDataGet('HM450.1.TCGA.PAAD')$betas
## add output to create an actual file
df <- createUCSCtrack(betas.tissue)

## to convert to bigBed
## sort -k1,1 -k2,2n output.bed >output_sorted.bed
## bedToBigBed output_sorted.bed hg38.chrom output.bb
}
