% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_signal.R
\name{viewGRangesWinSample_dt}
\alias{viewGRangesWinSample_dt}
\title{get a windowed sampling of score_gr}
\usage{
viewGRangesWinSample_dt(
  score_gr,
  qgr,
  window_size,
  attrib_var = "score",
  fill_value = 0,
  anchor = c("center", "center_unstranded", "left", "left_unstranded")[1]
)
}
\arguments{
\item{score_gr}{GRanges with a "score" metadata column.}

\item{qgr}{regions to view by window.}

\item{window_size}{qgr will be represented by value from score_gr every
window_size bp.}

\item{attrib_var}{character name of attribute to pull data from. Default is
"score", compatible with with bigWigs or bam coverage.}

\item{fill_value}{numeric or character value to use where queried regions are
empty.  Default is 0 and appropriate for both calculated coverage and
bedgraph/bigwig like files.  Will automatically switch to "MISSING" if data
is guessed to be qualitative.}

\item{anchor}{character. controls how x value is derived from position for
each region in qgr.  0 may be the left side or center.  If not unstranded,
x coordinates are flipped for (-) strand. One of c("center",
"center_unstranded", "left", "left_unstranded"). Default is "center".}
}
\value{
data.table that is GRanges compatible
}
\description{
This method is appropriate when all GRanges in qgr are identical width and
when it is practical to use a window_size smaller than features in genomic
signal.  For instance, when retrieving signal around peaks or promoters this
method maintains a fixed genomic scale across regions.  This allows meaingful
comparison of peak widths can be made.
}
\details{
Summarizes score_gr by grabbing value of "score" every window_size bp.
Columns in output data.table are: standard GRanges columns: seqnames, start,
end, width, strand id - matched to names(score_gr). if names(score_gr) is
missing, added as 1:length(score_gr). y - value of score from score_gr. x -
relative bp position.
}
\examples{
data(CTCF_in_10a_overlaps_gr)
bam_file = system.file("extdata/test.bam",
    package = "seqsetvis")
qgr = CTCF_in_10a_overlaps_gr[seq_len(5)]
qgr = GenomicRanges::resize(qgr, width = 500, fix = "center")
bam_gr = seqsetvis:::fetchBam(bam_file, qgr)
bam_dt = viewGRangesWinSample_dt(bam_gr, qgr, 50)

if(Sys.info()['sysname'] != "Windows"){
    bw_file = system.file("extdata/MCF10A_CTCF_FE_random100.bw",
        package = "seqsetvis")
    bw_gr = rtracklayer::import.bw(bw_file, which = qgr)
    bw_dt = viewGRangesWinSample_dt(bw_gr, qgr, 50)
}
}
