% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssvMakeMembTable.R
\name{ssvMakeMembTable}
\alias{ssvMakeMembTable}
\alias{ssvMakeMembTable,list-method}
\alias{ssvMakeMembTable,GRangesList-method}
\alias{ssvMakeMembTable,GRanges-method}
\alias{ssvMakeMembTable,DataFrame-method}
\alias{ssvMakeMembTable,matrix-method}
\alias{ssvMakeMembTable,data.frame-method}
\title{generic for methods to convert various objects to a logical matrix indicating
membership of items (rows) in sets (columns)}
\usage{
ssvMakeMembTable(object)

\S4method{ssvMakeMembTable}{list}(object)

\S4method{ssvMakeMembTable}{GRangesList}(object)

\S4method{ssvMakeMembTable}{GRanges}(object)

\S4method{ssvMakeMembTable}{DataFrame}(object)

\S4method{ssvMakeMembTable}{matrix}(object)

\S4method{ssvMakeMembTable}{data.frame}(object)
}
\arguments{
\item{object}{the object to convert. Supported types: list (of character
or GRanges), GRanges with membership table metadata, GRangesList,
data.frame/matrix/DataFrame of membership table}
}
\value{
a logical matrix indicating membership of items (rows) in sets
(columns)
}
\description{
generic for methods to convert various objects to a logical matrix indicating
membership of items (rows) in sets (columns)

list of character vectors input

GRangesList input

GRanges with mcols input

DataFrame input

matrix of logicals, membership table

data.frame input, final output
The final method for all inputs, checks column names and returns logical
matrix
}
\examples{
char_list = list(letters[1:3], letters[2:4])
ssvMakeMembTable(char_list)
library(GenomicRanges)
gr_list = list(GRanges("chr1", IRanges(1:3*2, 1:3*2)),
    GRanges("chr1", IRanges(2:4*2, 2:4*2)))
ssvMakeMembTable(gr_list)
library(GenomicRanges)
gr_list = list(GRanges("chr1", IRanges(1:3*2, 1:3*2)),
    GRanges("chr1", IRanges(2:4*2, 2:4*2)))
ssvMakeMembTable(GRangesList(gr_list))
gr = GRanges("chr1", IRanges(1:3*2, 1:3*2))
gr$set_a = c(TRUE, TRUE, FALSE)
gr$set_b = c(FALSE, TRUE, TRUE)
ssvMakeMembTable(gr)
gr = GRanges("chr1", IRanges(1:3*2, 1:3*2))
gr$set_a = c(TRUE, TRUE, FALSE)
gr$set_b = c(FALSE, TRUE, TRUE)
ssvMakeMembTable(mcols(gr))
memb_mat =  matrix(c(TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE),
    ncol = 2, byrow = FALSE)
ssvMakeMembTable(memb_mat)
memb_df = data.frame(a = c(TRUE, TRUE, FALSE, FALSE),
    b = c(TRUE, FALSE, TRUE, FALSE))
ssvMakeMembTable(memb_df)
}
