% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_bamPE.R
\name{ssvFetchBamPE.single}
\alias{ssvFetchBamPE.single}
\title{fetch a windowed version of a paired-end bam file, returns GRanges
In contrast to ssvFetchBam, extension of reads to estimated fragment size is
not an issue as each read pair represents a fragment of exact size.}
\usage{
ssvFetchBamPE.single(
  bam_f,
  qgr,
  win_size = 50,
  win_method = c("sample", "summary")[1],
  summary_FUN = stats::weighted.mean,
  anchor = c("left", "left_unstranded", "center", "center_unstranded")[3],
  return_data.table = FALSE,
  max_dupes = Inf,
  min_isize = 1,
  max_isize = Inf,
  return_unprocessed = FALSE,
  return_fragSizes = FALSE,
  force_skip_centerFix = FALSE,
  ...
)
}
\arguments{
\item{bam_f}{character or BamFile to load}

\item{qgr}{GRanges regions to fetchs}

\item{win_size}{numeric >=1.  pileup grabbed every win_size bp for win_method
sample.  If win_method is summary, this is the number of windows used
(confusing, sorry).}

\item{win_method}{character.  one of c("sample", "summary").  Determines if
\code{\link{viewGRangesWinSample_dt}} or
\code{\link{viewGRangesWinSummary_dt}} is used to represent each region in
qgr.}

\item{summary_FUN}{function.  only relevant if win_method is "summary".
passed to \code{\link{viewGRangesWinSummary_dt}}.}

\item{anchor}{character, one of c("center", "center_unstranded", "left",
"left_unstranded")}

\item{return_data.table}{logical. If TRUE the internal data.table is returned
instead of GRanges.  Default is FALSE.}

\item{max_dupes}{numeric >= 1.  duplicate reads by strandd start position
over this number are removed, Default is Inf.}

\item{min_isize}{integer. Read pairs must have an isize greater than or equal to this value.  Default is 1.}

\item{max_isize}{integer. Read pairs must have an isize less than or equal to this value.  Default is Inf.}

\item{return_unprocessed}{boolean. if TRUE returns read alignment in data.table. Default is FALSE.}

\item{return_fragSizes}{boolean. if TRUE returns fragment sizes for all reads per region.}

\item{force_skip_centerFix}{boolean, if TRUE all query ranges will be
used "as is".  This is already the case by default if win_method == "summary"
but may have applications where win_method == "sample".}

\item{...}{passed to Rsamtools::ScanBamParam()}
}
\value{
tidy GRanges (or data.table if specified) with pileups from bam file.
pileup is calculated only every win_size bp.
}
\description{
fetch a windowed version of a paired-end bam file, returns GRanges
In contrast to ssvFetchBam, extension of reads to estimated fragment size is
not an issue as each read pair represents a fragment of exact size.
}
