% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_clusteringKmeans.R
\name{split_cluster}
\alias{split_cluster}
\title{split_cluster}
\usage{
split_cluster(
  clust_dt,
  to_split,
  nclust = 2,
  row_ = "id",
  column_ = "x",
  fill_ = "y",
  facet_ = "sample",
  cluster_ = "cluster_id",
  reapply_cluster_names = TRUE
)
}
\arguments{
\item{clust_dt}{data.table output from \code{\link{ssvSignalClustering}}}

\item{to_split}{Cluster to split.}

\item{nclust}{Number of new clusters to create.}

\item{row_}{variable name mapped to row, likely id or gene name for ngs data.
Default is "id" and works with ssvFetch* output.}

\item{column_}{varaible mapped to column, likely bp position for ngs data.
Default is "x" and works with ssvFetch* output.}

\item{fill_}{numeric variable to map to fill. Default is "y" and works with
ssvFetch* output.}

\item{facet_}{variable name to facet horizontally by. Default is "sample" and
works with ssvFetch* output. Set to "" if data is not facetted.}

\item{cluster_}{variable name to use for cluster info. Default is
"cluster_id".}

\item{reapply_cluster_names}{If TRUE, clusters will be renamed according to
new order instead of their original names. Default is TRUE.}
}
\value{
data.table as output from \code{\link{ssvSignalClustering}}
}
\description{
Splits one specified cluster in number of new clusters determined by nclust
}
\examples{
data(CTCF_in_10a_profiles_dt)
set.seed(0)
clust_dt = ssvSignalClustering(CTCF_in_10a_profiles_dt, nclust = 3)
split_dt = split_cluster(clust_dt, to_split = 2, nclust = 3)
split_dt.no_rename = split_cluster(
  clust_dt,
  to_split = 2,
  nclust = 3,
  reapply_cluster_names = FALSE
)
cowplot::plot_grid(nrow = 1,
  ssvSignalHeatmap(clust_dt),
  ssvSignalHeatmap(split_dt),
  ssvSignalHeatmap(split_dt.no_rename)
)

}
