% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_clusteringKmeans.R
\name{reorder_clusters_stepdown}
\alias{reorder_clusters_stepdown}
\title{reorder_clusters_stepdown}
\usage{
reorder_clusters_stepdown(
  clust_dt,
  row_ = "id",
  column_ = "x",
  fill_ = "y",
  facet_ = "sample",
  cluster_ = "cluster_id",
  reapply_cluster_names = TRUE,
  step_by_column = TRUE,
  step_by_facet = FALSE
)
}
\arguments{
\item{clust_dt}{data.table output from \code{\link{ssvSignalClustering}}}

\item{row_}{variable name mapped to row, likely id or gene name for ngs data.
Default is "id" and works with ssvFetch* output.}

\item{column_}{varaible mapped to column, likely bp position for ngs data.
Default is "x" and works with ssvFetch* output.}

\item{fill_}{numeric variable to map to fill. Default is "y" and works with
ssvFetch* output.}

\item{facet_}{variable name to facet horizontally by. Default is "sample" and
works with ssvFetch* output. Set to "" if data is not facetted.}

\item{cluster_}{variable name to use for cluster info. Default is
"cluster_id".}

\item{reapply_cluster_names}{If TRUE, clusters will be renamed according to
new order instead of their original names. Default is TRUE.}

\item{step_by_column}{If TRUE, column is considered for left-right cluster
balance. Default is TRUE.}

\item{step_by_facet}{If TRUE, facet is considered for left-right cluster
balance. Default is FALSE.}
}
\value{
data.table as output from \code{\link{ssvSignalClustering}}
}
\description{
Attempts to reorder clusters so that rows with highest signal on the left
relative to the right appear at the top. Signal should have a roughly
diagonal pattern in a "stepdown" pattern.
}
\details{
This can be down by column (step_by_column = TRUE) which averages across
facets.  By facet (step_by_column = FALSE, step_by_facet = TRUE) which
averages all columns per facet. Or both column and facet (step_by_column =
TRUE, step_by_facet = TRUE), which does no averaging so it looks at the full
matrix as plotted.
}
\examples{
data(CTCF_in_10a_profiles_dt)
clust_dt = ssvSignalClustering(CTCF_in_10a_profiles_dt, nclust = 10)
new_dt = reorder_clusters_stepdown(clust_dt)
cowplot::plot_grid(
    ssvSignalHeatmap(clust_dt),
    ssvSignalHeatmap(new_dt)
)
}
