% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_bam.R
\name{harmonize_seqlengths}
\alias{harmonize_seqlengths}
\title{harmonize_seqlengths}
\usage{
harmonize_seqlengths(query_gr, bam_file, force_fix = FALSE)
}
\arguments{
\item{query_gr}{GRanges, object to harmonize seqlengths for}

\item{bam_file}{character, a path to a valid bam file}

\item{force_fix}{Logical, if TRUE incompatible seqnames are removed from the query_gr.  Default is FALSE.}
}
\value{
GRanges with seqlengths matching bam_file
}
\description{
ensures compatibility between seqlength of gr and bam_file based on header
}
\examples{
library(GenomicRanges)
query_gr = GRanges("chr1", IRanges(1, 100))
#seqlengths has not been set
seqlengths(query_gr)
bam = system.file("extdata/test.bam", package = "seqsetvis")
gr2 = harmonize_seqlengths(query_gr, bam)
#seqlengths now set
seqlengths(gr2)
}
