% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_clusteringKmeans.R
\name{clusteringKmeansNestedHclust}
\alias{clusteringKmeansNestedHclust}
\title{perform kmeans clustering on matrix rows and return reordered matrix along
with order matched cluster assignments clusters are sorted using hclust on
centers the contents of each cluster are sorted using hclust}
\usage{
clusteringKmeansNestedHclust(
  mat,
  nclust,
  within_order_strategy = valid_sort_strategies[2],
  centroids = NULL,
  manual_mapping = NULL,
  iter.max = 30
)
}
\arguments{
\item{mat}{A wide format matrix}

\item{nclust}{the number of clusters}

\item{within_order_strategy}{one of "hclust", "sort", "right", "left",
"reverse".  If "hclust", hierarchical clustering will be used. If "sort", a
simple decreasing sort of rosSums.  If "left", will atttempt to put high
signal on left ("right" is opposite).  If "reverse" reverses existing order
(should only be used after meaningful order imposed).}

\item{centroids}{optional matrix with same columns as mat and one centroid
per row to base clusters off of.  Overrides any setting to nclust. Default
of NULL results in randomly initialized k-means.}

\item{manual_mapping}{optional named vector manually specififying cluster
assignments. names should be item ids and values should be cluster names
the items are assigned to. Default of NULL allows clustering to proceed.}

\item{iter.max}{Number of max iterations to allow for k-means. Default is 30.}
}
\value{
data.table with 2 columns of cluster info. id__ column corresponds
with input matrix rownames and is sorted within each cluster using
hierarchical clusering group__ column indicates cluster assignment
}
\description{
perform kmeans clustering on matrix rows and return reordered matrix along
with order matched cluster assignments clusters are sorted using hclust on
centers the contents of each cluster are sorted using hclust
}
\examples{
data(CTCF_in_10a_profiles_dt)
dt = data.table::copy(CTCF_in_10a_profiles_dt)
mat = data.table::dcast(dt, id ~ sample + x, value.var = "y" )
rn = mat$id
mat = as.matrix(mat[,-1])
rownames(mat) = rn
clust_dt = clusteringKmeansNestedHclust(mat, nclust = 3)
clust_dt
}
