% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_clusteringKmeans.R
\name{clusteringKmeans}
\alias{clusteringKmeans}
\title{perform kmeans clustering on matrix rows and return reordered matrix along
with order matched cluster assignments. clusters are sorted using hclust on
centers}
\usage{
clusteringKmeans(mat, nclust, centroids = NULL, iter.max = 30)
}
\arguments{
\item{mat}{numeric matrix to cluster.}

\item{nclust}{the number of clusters.}

\item{centroids}{optional matrix with same columns as mat and one centroid
per row to base clusters off of.  Overrides any setting to nclust. Default
of NULL results in randomly initialized k-means.}

\item{iter.max}{Number of max iterations to allow for k-means. Default is 30.}
}
\value{
data.table with group__ variable indicating cluster membership and
id__ variable that is a factor indicating order based on within cluster
similarity
}
\description{
perform kmeans clustering on matrix rows and return reordered matrix along
with order matched cluster assignments. clusters are sorted using hclust on
centers
}
\examples{
data(CTCF_in_10a_profiles_dt)
dt = data.table::copy(CTCF_in_10a_profiles_dt)
mat = data.table::dcast(dt, id ~ sample + x, value.var = "y" )
rn = mat$id
mat = as.matrix(mat[,-1])
rownames(mat) = rn
clust_dt = clusteringKmeans(mat, nclust = 3)
dt = merge(dt, clust_dt[, .(id = id__, group = group__)])
dt$id = factor(dt$id, levels = clust_dt$id)
dt[order(id)]
}
