% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot similarity heatmap}
\usage{
plot_heatmap(similarities, cluster = TRUE, annotate = TRUE,
  annotate_size = 9, legend = TRUE, legend_size = c(36, 8),
  limits = c(0, 50, 90, 100), text_size = 14, colour = "#1954A6")
}
\arguments{
\item{similarities}{The long-format dataframe containing the data.}

\item{cluster}{Cluster the samples based on similarity (boolean).}

\item{annotate}{Annotate each cell with the score (boolean).}

\item{annotate_size}{Text size of the annotations (numeric).}

\item{legend}{Show a legend for the colour gradient (boolean).}

\item{legend_size}{Height and width of the legend (vector of two integers).}

\item{limits}{The limits for the colour gradient (vector of four integers).}

\item{text_size}{Text size for axes, labels and legend (numeric).}

\item{colour}{The main colour to use for the gradient (character).}
}
\value{
A ggplot2 graphical object.
}
\description{
Plot a heatmap of similarities from many-to-many SNV profile
 comparisons.
}
\details{
This function creates publication-ready plots of heatmaps for
many-to-many  sample comparisons, taking a long-format dataframe containing
the summary statistics of each comparison as input.
}
\examples{
# Load test similarities
data(test_similarities)

# Plot a similarity heatmap
heatmap <- plot_heatmap(test_similarities)
}
