% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{class}
\name{segmentation}
\alias{segmentation}
\alias{class:segmentation}
\alias{segmentation-class}
\title{segmentation objects}
\description{
The \code{segmentation} class consists of matrices and lists. The components
contain the output of the chromatin segmentation analysis. Loading the input
data is optional. The object is returned as a result of calling
\code{\link{learn_model}} or reading its already existing output.
}
\section{Slots}{

\describe{
\item{\code{model}}{list. The \code{list} consists of 6 items corresponding
to the contents of the \code{model_#.txt} file. These are
\code{number_states} and \code{number_marks} for the numbers of states
and marks in the model; \code{likelihood} and \code{probinit} for the
likelihood and the initial probabilities of the multi-state model;
\code{transitionprobs} and \code{emissionprobs} for the probabilities
of the transitions and emissions parameters of the model. Can be
accessed using \code{\link{model}}.}

\item{\code{emission}}{matrix. The \code{matrix} contains the emission
parameters of n states (rows) for n marks (columns) corresponding to
the contents of the \code{emission_#.txt} file. Can be accessed using
\code{\link{emission}}.}

\item{\code{transition}}{matrix. The \code{matrix} contains the transition
parameters of n by n states corresponding to the contents of the
\code{transition_#.txt} file. Can be accessed using
\code{\link{transition}}.}

\item{\code{overlap}}{list. A \code{list} of n number of cells/conditions items.
Each item is a \code{matrix} of the overlap enrichment of n states
(rows) at n genomic annotations (columns) corresponding to the contents
of the \code{<cell>_#_overlap.txt} files. Can be accessed using
\code{\link{overlap}}.}

\item{\code{TSS}}{list. A \code{list} of n number of cells/conditions items.
Each item is a \code{matrix} of the overlap enrichment of n states
(rows) at n locations around the transcription start site (TSS)
(columns) corresponding to the contents of the
\code{<cell>_#_TSS_neighborhood.txt} files. Can be accessed using
\code{\link{TSS}}.}

\item{\code{TES}}{list. A \code{list} of n number of cells/conditions items.
Each item is a \code{matrix} of the overlap enrichment of n states
(rows) at n locations around the transcription end site (TES)
(columns) corresponding to the contents of the
\code{<cell>_#_TES_neighborhood.txt} files. Can be accessed using
\code{\link{TES}}.}

\item{\code{segment}}{list. A \code{list} of n number of cells/conditions items.
Each item is a \code{\link[GenomicRanges]{GRanges}} object containing the
segmentation and assigned states as a metadata column 'state'. These
contents correspond to the \code{<cell>_#_segment.bed} files. Annotations
of the ranges are optional. Can be accessed using \code{\link{segment}}.}

\item{\code{bins}}{list. A \code{list} of n number of cells/conditions items.
Each item is a \code{\link[SummarizedExperiment]{SummarizedExperiment}}
object containing the binarized input data. The coordinates of the bins
are saved as the \code{\link[SummarizedExperiment]{rowRanges}} each
assigned to a state and the binary data itself is saved as
\code{\link[SummarizedExperiment]{assay}}. Can be accessed using
\code{\link{bins}}.}

\item{\code{counts}}{list. A \code{list} of n number of cells/conditions items.
Each item is a \code{\link[SummarizedExperiment]{SummarizedExperiment}}
object containing the read counts in bins. The coordinates of the bins
are saved as the \code{\link[SummarizedExperiment]{rowRanges}} each
assigned to a state and the counts data itself is saved as
\code{\link[SummarizedExperiment]{assay}}. Can be accessed using
\code{\link{counts}}.}
}}

\seealso{
\code{\link{learn_model}}
}
