% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{sortRows}
\alias{sortRows}
\title{sortRows}
\usage{
sortRows(
  x,
  z = FALSE,
  toporder = NULL,
  na.rm = FALSE,
  method = "MDS_angle",
  toporder.meth = "before"
)
}
\arguments{
\item{x}{A numeric matrix or data.frame.}

\item{z}{Whether to scale rows for the purpose of calculating order.}

\item{toporder}{Optional verctor of categories (length=nrow(x)) on which to
supra-order  when sorting rows.}

\item{na.rm}{Whether to remove missing values and invariant rows.}

\item{method}{Seriation method; 'MDS_angle' (default) or 'R2E' recommended.}

\item{toporder.meth}{Whether to perform higher-order sorting 'before'
(default) or 'after' the lower-order sorting.}
}
\value{
A reordered matrix or data.frame.
}
\description{
sortRows
}
\examples{
# random data
m <- matrix( round(rnorm(100,mean=10, sd=2)), nrow=10,
             dimnames=list(LETTERS[1:10], letters[11:20]) )
m
sortRows(m)

}
