% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/master.R
\name{revive_xfplate}
\alias{revive_xfplate}
\title{Running the read, preprocess and validate}
\usage{
revive_xfplate(filepath_seahorse)
}
\arguments{
\item{filepath_seahorse}{Absolute path to the Seahorse Excel file.}
}
\value{
A preprocessed seahorse dataset is returned as an output. This is a nested tibble with the following 7 columns: \cr
 * plate_id = Barcode plate id of the well plate containing the samples \cr
 * filepath_seahorse = Path, and basename to .xlsx input file \cr
 * date_run = Date and time when the plate was run \cr
 * date_processed = Date and time this output from revive_xfplate() was generated \cr
 * assay_info = Meta information from 'Assay Configuration' sheet and 'Calibration' sheet \cr
 * injection_info = Dataframe with information from the 'Operation log' sheet \cr
 * raw_data = Preprocessed raw dataframe from 'Raw' sheet \cr
 * rate_data = Preprocessed rate data from 'Rate' sheet \cr
 # validation_output = Output of the data checks. including rules
}
\description{
This function takes the Seahorse Wave .xlsx file and computes it through
read, validate and preprocess
}
\examples{
revive_xfplate(
    system.file("extdata",
        "20191219_SciRep_PBMCs_donor_A.xlsx",
        package = "seahtrue"
    )
)

}
