% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchBarcodes.R
\name{matchBarcodes}
\alias{matchBarcodes}
\title{Match sequences to a pool of barcodes}
\usage{
matchBarcodes(sequences, choices, substitutions = 0, reverse = FALSE)
}
\arguments{
\item{sequences}{Character vector of observed sequences.}

\item{choices}{Character vector of barcode sequences.}

\item{substitutions}{Integer scalar specifying the maximum number of substitutions when considering a match.}

\item{reverse}{Whether to match \code{sequences} to the reverse complement of \code{choices}.}
}
\value{
\linkS4class{DataFrame} with one row per entry of \code{sequences}, containing the following fields:
\itemize{
\item \code{index}, the index of the matching barcode in \code{choices}.
This is set to \code{NA} if no unambiguous match is found.
\item \code{mismatches}, the number of mismatching bases with the assigned barcode.
This is set to \code{NA} if \code{index} is \code{NA}.
}
}
\description{
Pretty much what it says on the tin.
Useful for matching observed sequences (e.g., from \code{\link{countRandomBarcodes}}) to a pool of known barcode sequences,
accounting for substitutions and ambiguous IUPAC codes.
}
\examples{
choices <- c("AAAAAA", "CCCCCC", "GGGGGG", "TTTTTT")
matchBarcodes(c("AAAAAA", "AAATAA"), choices)
matchBarcodes(c("AAAAAA", "AAATAA"), choices, substitutions=1)
matchBarcodes(c("AAAAAA", "AAATAA"), choices, reverse=TRUE)

# Works with IUPAC codes in the barcodes:
choices <- c("AAARAA", "CCCYCC", "GGGMGG", "TTTSTT")
matchBarcodes(c("AAAAAA", "AAAGAA"), choices)

}
\author{
Aaron Lun
}
