% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateAcrossCells.R
\name{aggregateAcrossCells}
\alias{aggregateAcrossCells}
\title{Aggregate expression across cells}
\usage{
aggregateAcrossCells(x, factors, num.threads = 1)
}
\arguments{
\item{x}{A matrix-like object where rows correspond to genes or genomic features and columns correspond to cells.
Values are typically expected to be counts.}

\item{factors}{A list or data frame containing one or more grouping factors, see \code{\link{combineFactors}}.}

\item{num.threads}{Integer specifying the number of threads to be used for aggregation.}
}
\value{
A list containing:
\itemize{
\item \code{sums}, a numeric matrix where each row corresponds to a gene and each column corresponds to a unique combination of levels from \code{factors}.
Each entry contains the summed expression across all cells with that combination. 
\item \code{detected}, an integer matrix where each row corresponds to a gene and each column corresponds to a unique combination of levels from \code{factors}.
Each entry contains the number of cells with detected expression in that combination.
\item \code{combinations}, a data frame containing the unique combination of levels from \code{factors}.
Rows of this data frame correspond to columns of \code{sums} and \code{detected}, while columns correspond to the factors in \code{factors}.
\item \code{counts}, the number of cells associated with each combination.
Each entry corresponds to a row of \code{combinations}.
\item \code{index}, an integer vector of length equal to the number of cells in \code{x}.
This specifies the combination in \code{combinations} to which each cell was assigned.
}
}
\description{
Aggregate expression values across cells based on one or more grouping factors.
This is usually applied to a count matrix to create pseudo-bulk profiles for each cluster/sample combination.
These profiles can then be used as if they were counts from bulk data, e.g., for differential analyses with \pkg{edgeR}.
}
\examples{
# Mocking a matrix:
library(Matrix)
x <- round(abs(rsparsematrix(1000, 100, 0.1) * 100))

# Simple aggregation:
clusters <- sample(LETTERS, 100, replace=TRUE)
agg <- aggregateAcrossCells(x, list(cluster=clusters))
str(agg)

# Multi-factor aggregation
samples <- sample(1:5, 100, replace=TRUE)
agg2 <- aggregateAcrossCells(x, list(cluster=clusters, sample=samples))
str(agg2)

}
\seealso{
The \code{aggregate_across_cells} function in \url{https://libscran.github.io/scran_aggregate/}.

\code{\link{aggregateAcrossGenes}}, to aggregate expression values across gene sets.
}
\author{
Aaron Lun
}
