% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreInvHapRes_class.R
\docType{class}
\name{scoreInvHapRes}
\alias{scoreInvHapRes}
\alias{scoreInvHapRes-class}
\alias{scoreInvHapRes-methods}
\alias{classification,scoreInvHapRes-method}
\alias{classification}
\alias{certainty,scoreInvHapRes-method}
\alias{certainty}
\alias{diffscores,scoreInvHapRes-method}
\alias{diffscores}
\alias{maxscores,scoreInvHapRes-method}
\alias{maxscores}
\alias{numSNPs,scoreInvHapRes-method}
\alias{numSNPs}
\alias{plotCallRate,scoreInvHapRes-method}
\alias{plotCallRate}
\alias{plotScores,scoreInvHapRes-method}
\alias{plotScores}
\alias{propSNPs,scoreInvHapRes-method}
\alias{propSNPs}
\alias{scores,scoreInvHapRes-method}
\alias{scores}
\title{scoreInvHapRes instances}
\usage{
\S4method{classification}{scoreInvHapRes}(object, minDiff = 0, callRate = 0, inversion = TRUE)

\S4method{certainty}{scoreInvHapRes}(object)

\S4method{diffscores}{scoreInvHapRes}(object)

\S4method{maxscores}{scoreInvHapRes}(object)

\S4method{numSNPs}{scoreInvHapRes}(object)

\S4method{plotCallRate}{scoreInvHapRes}(object, callRate = 0.9, ...)

\S4method{plotScores}{scoreInvHapRes}(object, minDiff = 0.1, ...)

\S4method{propSNPs}{scoreInvHapRes}(object)

\S4method{scores}{scoreInvHapRes}(object)
}
\arguments{
\item{object}{\code{scoreInvHapRes}}

\item{minDiff}{Numeric with the threshold of the minimum difference
between the top and the second score. Used to filter samples.}

\item{callRate}{Numeric with the threshold of the minimum call rate
of the samples. Used to filter samples.}

\item{inversion}{Logical. If true, haplotypes classification is adapted
to return inversion status. (Default: TRUE)}

\item{...}{Further parameters passed to plot function.}
}
\value{
A scoreInvHapRes instance
}
\description{
Container with the results of the classification pipeline
}
\section{Methods (by generic)}{
\itemize{
\item \code{classification}: Get classification

\item \code{certainty}: Get classification certainty

\item \code{diffscores}: Get maximum similarity scores

\item \code{maxscores}: Get maximum similarity scores

\item \code{numSNPs}: Get number of SNPs used in computation

\item \code{plotCallRate}: Plot call rate based QC

\item \code{plotScores}: Plot scores based QC

\item \code{propSNPs}: Get proportions of SNPs used in computation

\item \code{scores}: Get similarity scores
}}

\section{Slots}{

\describe{
\item{\code{classification}}{Factor with the individuals classification}

\item{\code{scores}}{Simmilarity scores for the different haplotypes.}

\item{\code{numSNPs}}{Numeric with SNPs used to compute the scores.}

\item{\code{certainty}}{Numeric with the certainty of the classification for each individual.}
}}

\examples{
if(require(VariantAnnotation)){
    vcf <- readVcf(system.file("extdata", "example.vcf", package = "scoreInvHap"), "hg19")

    ## Create scoreInvHapRes class from pipeline
    res <- scoreInvHap(vcf, inv = "inv7_005")

    ## Print object
    res

    ## Get haplotype classification
    classification(res)

    ## Get similiraty scores
    scores(res)
}
}
