\name{cellCellSetting}
\docType{methods}
\alias{cellCellSetting,SingleCellExperiment-method}
\alias{cellCellSetting}

\title{
Parameter setting for scTensor
}
\description{
All parameters is saved to metadata slot of SingleCellExperiment object.
}
\usage{
cellCellSetting(sce, lrbase, label, lr.evidence="known", color=NULL)
}

\arguments{
\item{sce}{
A object generated by instantization of SingleCellExperiment-class.
}
\item{lrbase}{
Ligand-Receptor database (LRBase.XXX.eg.db-type package).
}
\item{label}{
Cellular label information for distingusishing
which cells belong to common celltypes.
}
\item{lr.evidence}{
The evidence code for L-R pair list (Default: "known").
When you specify "known", DLRP, IUPHAR, HPMR, CELLPHONEDB, SINGLECELLSIGNALR are searched, and other databases are searched, when you specify "putative".
You can also specify multiple databases at once (e.g. c("SWISSPROT_STRING", "TREMBL_STRING")).
cf. https://github.com/rikenbit/lrbase-workflow
}
\item{color}{
Color scheme for adding color against the cells (Default: NULL).
If the value is not specified, automatically the color vector is generated.
}
}

\value{
The result is saved to metadata slot of SingleCellExperiment object.
}
\seealso{
\code{\link[SingleCellExperiment]{SingleCellExperiment}}.
}

\author{Koki Tsuyuzaki}

\examples{
showMethods("cellCellSetting")
}

\keyword{methods}