% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentKmer.R
\name{percentKmer}
\alias{percentKmer}
\title{Analyze K-mer Motif Composition}
\usage{
percentKmer(
  input.data,
  chain = "TRB",
  cloneCall = "aa",
  group.by = NULL,
  order.by = NULL,
  motif.length = 3,
  min.depth = 3,
  top.motifs = 30,
  exportTable = FALSE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}},
\code{\link[=combineBCR]{combineBCR()}}, or \code{\link[=combineExpression]{combineExpression()}}}

\item{chain}{The TCR/BCR chain to use. Use \code{both} to include both chains
(e.g., TRA/TRB). Accepted values: \code{TRA}, \code{TRB}, \code{TRG}, \code{TRD}, \code{IGH}, \code{IGL},
\code{IGK}, \code{Light} (for both light chains), or \code{both} (for TRA/B and Heavy/Light).}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{nt} (CDR3 nucleotide sequence) or \code{aa} (CDR3 amino acid sequence).}

\item{group.by}{A column header in the metadata or lists to group the analysis
by (e.g., "sample", "treatment"). If \code{NULL}, data will be analyzed as
by list element or active identity in the case of single-cell objects.}

\item{order.by}{A character vector defining the desired order of elements
of the \code{group.by} variable. Alternatively, use \code{alphanumeric} to sort groups
automatically.}

\item{motif.length}{The length of the kmer to analyze}

\item{min.depth}{Minimum count a motif must reach to be retained in the
output (\verb{>= 1}). \strong{Default:} \code{3}.}

\item{top.motifs}{Return the n most variable motifs as a function of
median absolute deviation}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any
\link[grDevices:palettes]{hcl.pals}}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
A ggplot object displaying a heatmap of motif percentages.
If \code{exportTable = TRUE}, a matrix of the raw data is returned.
}
\description{
This function calculates and visualizes the frequency of k-mer
motifs for either nucleotide (nt) or amino acid (aa) sequences. It produces
a heatmap showing the relative composition of the most variable motifs across
samples or groups.
}
\details{
The function first calculates k-mer frequencies for each sample/group.
By default, it then identifies the 30 most variable motifs based on the Median
Absolute Deviation (MAD) across all samples and displays their frequencies
in a heatmap.
}
\examples{
# Making combined contig data
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))

# Using percentKmer()
percentKmer(combined, 
            chain = "TRB", 
            motif.length = 3)

}
\concept{Summarize_Repertoire}
