% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_atac_feature_counting.R
\name{sc_atac_feature_counting}
\alias{sc_atac_feature_counting}
\title{generating the feature by cell matrix}
\usage{
sc_atac_feature_counting(
  fragment_file,
  feature_input = NULL,
  bam_tags = list(bc = "CB", mb = "OX"),
  feature_type = "peak",
  organism = "hg38",
  cell_calling = "filter",
  sample_name = "",
  genome_size = NULL,
  promoters_file = NULL,
  tss_file = NULL,
  enhs_file = NULL,
  gene_anno_file = NULL,
  pheno_data = NULL,
  bin_size = NULL,
  yieldsize = 1e+06,
  n_filter_cell_counts = 200,
  n_filter_feature_counts = 10,
  exclude_regions = FALSE,
  excluded_regions_filename = NULL,
  output_folder = NULL,
  fix_chr = "none",
  lower = NULL,
  min_uniq_frags = 3000,
  max_uniq_frags = 50000,
  min_frac_peak = 0.3,
  min_frac_tss = 0,
  min_frac_enhancer = 0,
  min_frac_promoter = 0.1,
  max_frac_mito = 0.15,
  create_report = FALSE
)
}
\arguments{
\item{fragment_file}{The fragment file}

\item{feature_input}{The feature input data e.g. the .narrowPeak file for peaks of a bed file format}

\item{bam_tags}{The BAM tags}

\item{feature_type}{The type of feature}

\item{organism}{The organism type (contains hg19, hg38, mm10)}

\item{cell_calling}{The desired cell calling method; either \code{cellranger}, \code{emptydrops} or  \code{filter}.}

\item{sample_name}{The sample name to identify which is the data is analysed for.}

\item{genome_size}{The size of the genome (used for the \code{cellranger} cell calling method)}

\item{promoters_file}{The path of the promoter annotation file (if the specified organism isn't recognised).}

\item{tss_file}{The path of the tss annotation file (if the specified organism isn't recognised).}

\item{enhs_file}{The path of the enhs annotation file (if the specified organism isn't recognised).}

\item{gene_anno_file}{The path of the gene annotation file (gtf or gff3 format).}

\item{pheno_data}{The phenotypic data as a data frame}

\item{bin_size}{The size of the bins}

\item{yieldsize}{The yield size}

\item{n_filter_cell_counts}{An integer value to filter the feature matrix on the number of reads per cell (default = 200)}

\item{n_filter_feature_counts}{An integer value to filter the feature matrix on the number of reads per feature (default = 10).}

\item{exclude_regions}{Whether or not the regions (specified in the file) should be excluded}

\item{excluded_regions_filename}{The filename of the file containing the regions to be excluded}

\item{output_folder}{The output folder}

\item{fix_chr}{Whether chr should be fixed or not}

\item{lower}{the lower threshold for the data if using the \code{emptydrops} function for cell calling}

\item{min_uniq_frags}{The minimum number of required unique fragments required for a cell (used for \code{filter} cell calling)}

\item{max_uniq_frags}{The maximum number of required unique fragments required for a cell (used for \code{filter} cell calling)}

\item{min_frac_peak}{The minimum proportion of fragments in a cell to overlap with a peak (used for \code{filter} cell calling)}

\item{min_frac_tss}{The minimum proportion of fragments in a cell to overlap with a tss (used for \code{filter} cell calling)}

\item{min_frac_enhancer}{The minimum proportion of fragments in a cell to overlap with a enhancer sequence (used for \code{filter} cell calling)}

\item{min_frac_promoter}{The minimum proportion of fragments in a cell to overlap with a promoter sequence (used for \code{filter} cell calling)}

\item{max_frac_mito}{The maximum proportion of fragments in a cell that are mitochondrial (used for \code{filter} cell calling)}

\item{create_report}{Logical value to say whether to create the report or not (default = TRUE).}
}
\value{
None (invisible `NULL`)
}
\description{
feature matrix is created using a given demultiplexed BAM file and 
a selected feature type
}
\examples{
\dontrun{
sc_atac_feature_counting(
   fragment_file = fragment_file,
   cell_calling = "filter",
   exclude_regions = TRUE,
   feature_input = feature_file)
}    
}
