% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCzinb_internal.R
\name{zinb1.noT}
\alias{zinb1.noT}
\title{Structure learning with zero-inflated negative binomial model}
\usage{
zinb1.noT(X, maxcard, alpha, extend, nCores = 1)
}
\arguments{
\item{X}{the matrix of counts (n times p).}

\item{maxcard}{the uper bound of the cardinality of the conditional sets K}

\item{alpha}{the significant level of the tests}

\item{extend}{if TRUE it considers the union of the tests, otherwise it
considers the intersection.}

\item{nCores}{number of cores for parallelization}
}
\value{
the estimated adjacency matrix of the graph.
}
\description{
This function estimates the adjacency matrix of a ZINB model given a matrix
of counts, using the optim function. Uses BiocParallel for parallelization.
}
\details{
This approach assumes that the structure of the graph depends on both the
mean parameter and the zero inflation parameter. We call this model \code{zinb1}.
}
\keyword{internal}
